// blitter.c

#include "main.h"
#include "gworld.h"
#include "blitter.h"
#include "wdef.h"
#include "font.h"
#include "level.h"
#include "graphics.h"

Boolean update[2][kGridAcross][kGridDown];
Boolean refresh[2];

void InitBlitter( void )
{
	int player, x, y;

	for( player=0; player<=1; player++ )
	{
		refresh[player] = false;
		
		for( x=0; x<kGridAcross; x++ )
		{
			for( y=0; y<kGridDown; y++ )
			{
				update[player][x][y] = false;
			}
		}
	}
}

void UpdatePlayerWindow( int player )
{
	int x,y;
	
	if( control[player] == kNobodyControl ) return;
	
	SetPort( backdropPort );
	
	if( playerWindowVisible[player] && refresh[player] )
	{
		Rect updateRect = {0, 0, 0, 0}, fullRect, offsetRect;
		Boolean first = true;
		
		for( x=0; x<kGridAcross; x++ )
		{
			for( y=1; y<kGridDown; y++ )
			{
				if( update[player][x][y] )
				{
					updateRect.top  = y * kBlobVertSize;
					updateRect.left = x * kBlobHorizSize;
					updateRect.bottom = updateRect.top + kBlobVertSize;
					updateRect.right = updateRect.left + kBlobHorizSize;
					if( first )
					{
						fullRect = updateRect;
						first = false;
					}
					else
					{
						UnionRect( &fullRect, &updateRect, &fullRect );
					}

					update[player][x][y] = false;
				}
			}
		}

		if( !first )
		{
			offsetRect = fullRect;
			OffsetRect( &offsetRect, playerWindowRect[player].left, playerWindowRect[player].top - kBlobVertSize );
			
			ForeColor( blackColor );
			BackColor( whiteColor );
			
			CopyBits( GetPortBitMapForCopyBits(playerSpriteWorld[player]),
						GetPortBitMapForCopyBits(backdropPort),
					  &fullRect, 
					  	&offsetRect,
					  srcCopy,
					  	nil );
		}
	}
}

void SetUpdateRect( int player, Rect *where )
{
	int x,y;
	int xMin, xMax, yMin, yMax;
	
	xMin = where->left / kBlobHorizSize;
	xMax = ( where->right + kBlobHorizSize - 1 ) / kBlobHorizSize;
	
	if( xMin < 0 ) xMin = 0;
	if( xMin > (kGridAcross-1) ) xMin = kGridAcross-1;
	if( xMax < 0 ) xMax = 0;
	if( xMax > kGridAcross ) xMax = kGridAcross;
	
	yMin = where->top / kBlobVertSize;
	yMax = ( where->bottom + kBlobVertSize - 1 ) / kBlobVertSize;

	if( yMin < 0 ) yMin = 0;
	if( yMin > (kGridDown-1) ) yMin = kGridDown-1;
	if( yMax < 0 ) yMax = 0;
	if( yMax > kGridDown ) yMax = kGridDown;
	
	for( x=xMin; x<xMax; x++ )
	{
		for( y=yMin; y<yMax; y++ )
		{
			update[player][x][y] = true;
		}
	}
	
	refresh[player] = true;
}

void BlitBlobMask( Rect *srcRect, Rect *dstRect )
{
	PixMapHandle sPixMap, mPixMap, dPixMap;
	int startX = 0, startY = 0, endX, endY, x, y, srcRowBytes, mskRowBytes, dstRowBytes;
	UInt32 bit, startBit, mask;
	Byte *src, *msk, *dst;
	GrafPtr thePort;
	
	GetPort( &thePort );
	sPixMap = GetGWorldPixMap( blobWorld );
	mPixMap = GetGWorldPixMap( maskWorld );
	dPixMap = GetPortPixMap( thePort );
	
	endX = srcRect->right - srcRect->left;
	endY = srcRect->bottom - srcRect->top;

	if( dstRect->left   > (**dPixMap).bounds.right  ||			// completely clipped?
		dstRect->right  < (**dPixMap).bounds.left   ||
		dstRect->top    > (**dPixMap).bounds.bottom ||
		dstRect->bottom < (**dPixMap).bounds.top )
	{
		return; 												// do nothing
	}
	
	src = (Byte*) GetPixBaseAddr(sPixMap);
	msk = (Byte*) GetPixBaseAddr(mPixMap);
	dst = (Byte*) GetPixBaseAddr(dPixMap);
	srcRowBytes = GetPixRowBytes(sPixMap);
	mskRowBytes = GetPixRowBytes(mPixMap);
	dstRowBytes = GetPixRowBytes(dPixMap);
	
	src += (srcRect->top * srcRowBytes) + (srcRect->left * 2);
	msk += (srcRect->top * mskRowBytes) + (srcRect->left / 8);
	dst += (dstRect->top * dstRowBytes) + (dstRect->left * 2);
	
	if( dstRect->left   < (**dPixMap).bounds.left   ) startX -= dstRect->left - (**dPixMap).bounds.left;
	if( dstRect->right  > (**dPixMap).bounds.right  ) endX   -= dstRect->right - (**dPixMap).bounds.right;
	if( dstRect->top    < (**dPixMap).bounds.top    ) startY -= dstRect->top - (**dPixMap).bounds.top;
	if( dstRect->bottom > (**dPixMap).bounds.bottom ) endY   -= dstRect->bottom - (**dPixMap).bounds.bottom;
	
	startBit = 0x80000000 >> (startX & 31);
	msk += (mskRowBytes * startY) + ((startX & ~31) / 8);
	src += (srcRowBytes * startY) + (startX * 2);
	dst += (dstRowBytes * startY) + (startX * 2);

	for( y=startY; y<endY; y++ )
	{
		Byte *tSrc = src, *tDst = dst, *tMsk = msk;
		
		mask = *(int*)msk;
		bit = startBit;
		
		for( x=startX; x<endX; x++ )
		{
			if( mask & bit )
			{
				*(short*)dst = *(short*)src;
			}
			
			if( !(bit >>= 1) ) { msk+=4; mask = *(int*)msk; bit = 0x80000000; }
			src+=2; dst+=2;
		}
		
		src = tSrc + srcRowBytes;
		dst = tDst + dstRowBytes;
		msk = tMsk + mskRowBytes;
	}
}
/*
void BlitLightMask( PixMapHandle mPixMap, Rect *srcRect, Rect *dstRect )
{
	PixMapHandle dPixMap;
	int startX = 0, startY = 0, endX, endY, x, y, bit, startBit, srcRowBytes, dstRowBytes;
	Byte *src, *dst;
		
	dPixMap = GetGWorldPixMap( (CGrafPtr) qd.thePort );
	
	endX = srcRect->right - srcRect->left;
	endY = srcRect->bottom - srcRect->top;

	if( dstRect->left   > (**dPixMap).bounds.right  ||			// completely clipped?
		dstRect->right  < (**dPixMap).bounds.left   ||
		dstRect->top    > (**dPixMap).bounds.bottom ||
		dstRect->bottom < (**dPixMap).bounds.top )
	{
		return; 												// do nothing
	}
	
	src = (Byte*) (**mPixMap).baseAddr;
	dst = (Byte*) (**dPixMap).baseAddr;
	srcRowBytes = (**mPixMap).rowBytes & 0x3FFF;
	dstRowBytes = (**dPixMap).rowBytes & 0x3FFF;
	
	src += (srcRect->top * srcRowBytes) + (srcRect->left / 8);
	dst += (dstRect->top * dstRowBytes) + (dstRect->left * 2);
	
	if( dstRect->left   < (**dPixMap).bounds.left   ) startX -= dstRect->left - (**dPixMap).bounds.left;
	if( dstRect->right  > (**dPixMap).bounds.right  ) endX   -= dstRect->right - (**dPixMap).bounds.right;
	if( dstRect->top    < (**dPixMap).bounds.top    ) startY -= dstRect->top - (**dPixMap).bounds.top;
	if( dstRect->bottom > (**dPixMap).bounds.bottom ) endY   -= dstRect->bottom - (**dPixMap).bounds.bottom;
	
	src += (srcRowBytes * startY) + (startX / 8);
	dst += (dstRowBytes * startY) + (startX * 2);
	startBit = 0x80 >> (startX & 7);

	for( y=startY; y<endY; y++ )
	{
		Byte *tSrc = src, *tDst = dst;
		int work, workB, workG, workR;
		
		bit = startBit;
		for( x=startX; x<endX; x++ )
		{
			if( *src & bit )
			{
				work = *(short*)dst;
				workB = ((((work    ) & 0x001F)*23) + (0x1F*9)) >> 5;
				workG = ((((work>> 5) & 0x001F)*23) + (0x1F*9));
				workR = ((((work>>10) & 0x001F)*23) + (0x1F*9)) << 5;

				*(short*)dst = (workR & 0x7C00) | (workG & 0x03E0) | (workB & 0x001F);
			}
			
			if( !(bit >>= 1) ) { src++; bit = 0x80; }
			dst+=2;
		}
		
		src = tSrc + srcRowBytes;
		dst = tDst + dstRowBytes;
	}
}
*/
void BlitAlphaMask( PixMapHandle bPixMap, PixMapHandle sPixMap, PixMapHandle aPixMap, Rect *bckRect, Rect *srcRect, Rect *alfRect, Rect *dstRect )
{
	PixMapHandle dPixMap;
	int startX = 0, startY = 0, endX, endY, x, y, srcRowBytes, alfRowBytes, dstRowBytes, bckRowBytes;
	Byte *bck, *src, *alf, *dst;
	GrafPtr thePort;
	
	GetPort( &thePort );
	dPixMap = GetPortPixMap( thePort );
	
	endX = srcRect->right - srcRect->left;
	endY = srcRect->bottom - srcRect->top;

	if( dstRect->left   > (**dPixMap).bounds.right  ||			// completely clipped?
		dstRect->right  < (**dPixMap).bounds.left   ||
		dstRect->top    > (**dPixMap).bounds.bottom ||
		dstRect->bottom < (**dPixMap).bounds.top )
	{
		return; 												// do nothing
	}
	
	bck = (Byte*) GetPixBaseAddr(bPixMap); 
	src = (Byte*) GetPixBaseAddr(sPixMap); 
	alf = (Byte*) GetPixBaseAddr(aPixMap);
	dst = (Byte*) GetPixBaseAddr(dPixMap); 
	bckRowBytes = GetPixRowBytes(bPixMap); 
	srcRowBytes = GetPixRowBytes(sPixMap);
	alfRowBytes = GetPixRowBytes(aPixMap);
	dstRowBytes = GetPixRowBytes(dPixMap);
	
	bck += (bckRect->top * bckRowBytes) + (bckRect->left * 2);
	src += (srcRect->top * srcRowBytes) + (srcRect->left * 2);
	alf += (alfRect->top * alfRowBytes) + (alfRect->left * 2);
	dst += (dstRect->top * dstRowBytes) + (dstRect->left * 2);
	
	if( dstRect->left   < (**dPixMap).bounds.left   ) startX -= dstRect->left - (**dPixMap).bounds.left;
	if( dstRect->right  > (**dPixMap).bounds.right  ) endX   -= dstRect->right - (**dPixMap).bounds.right;
	if( dstRect->top    < (**dPixMap).bounds.top    ) startY -= dstRect->top - (**dPixMap).bounds.top;
	if( dstRect->bottom > (**dPixMap).bounds.bottom ) endY   -= dstRect->bottom - (**dPixMap).bounds.bottom;
	
	bck += (bckRowBytes * startY) + (startX * 2);
	src += (srcRowBytes * startY) + (startX * 2);
	alf += (alfRowBytes * startY) + (startX * 2);
	dst += (dstRowBytes * startY) + (startX * 2);

	for( y=startY; y<endY; y++ )
	{
		Byte *tSrc = src, *tAlf = alf, *tDst = dst, *tBck = bck;
		int pixS, pixB, weightS, weightB, workB, workG, workR;
		
		for( x=startX; x<endX; x++ )
		{
			weightB = *(short*)alf;
			
			if( weightB == 0x7FFF )
			{
				*(short*)dst = *(short*)bck;
			}
			else if( weightB == 0 )
			{
				*(short*)dst = *(short*)src;
			}
			else
			{
				weightS = ~weightB;

				pixS = *(short*)src;
				pixB = *(short*)bck;
								
				workB = ((((pixS      ) & 0x001F) * ((weightS      ) & 0x001F)) + (((pixB      ) & 0x001F) * ((weightB      ) & 0x001F))) >> 5;
				workG = ((((pixS >>  5) & 0x001F) * ((weightS >>  5) & 0x001F)) + (((pixB >>  5) & 0x001F) * ((weightB >>  5) & 0x001F)));
				workR = ((((pixS >> 10) & 0x001F) * ((weightS >> 10) & 0x001F)) + (((pixB >> 10) & 0x001F) * ((weightB >> 10) & 0x001F))) << 5;

				*(short*)dst = (workR & 0x7C00) | (workG & 0x03E0) | (workB & 0x001F);
			}

			src+=2;
			alf+=2;
			bck+=2;
			dst+=2;
		}
		
		bck = tBck + bckRowBytes;
		src = tSrc + srcRowBytes;
		alf = tAlf + alfRowBytes;
		dst = tDst + dstRowBytes;
	}
}

void BlitCharacter( SkittlesFontPtr font, unsigned char text, Point *dPoint, int r, int g, int b, int dropShadow )
{
	PixMapHandle dPixMap;
	Byte *src, *dst;
	int srcRowBytes, dstRowBytes;
	int index;
	int rgb555;
	GrafPtr thePort;
	
	int height = font->height;
	int width  = font->width[text];
	int across = font->across[text];
	
	GetPort( &thePort );
	dPixMap = GetPortPixMap( thePort );
	
	if( (dPoint->h + width)  > (**dPixMap).bounds.right           ||      // clipped?
	    (dPoint->v + height) > (**dPixMap).bounds.bottom          || 
	    dPoint->h < (**dPixMap).bounds.left ||
	    dPoint->v < (**dPixMap).bounds.top     )
	{
		dPoint->h += width;
		return;                                               // do nothing
	}
	
	srcRowBytes = font->rowBytes;
	dstRowBytes = GetPixRowBytes(dPixMap);
	
	src = (Byte*) GetPixBaseAddr( font-> pixMap ) + across;
	dst = (Byte*) GetPixBaseAddr(       dPixMap ) + (dPoint->h * 2) + (dPoint->v * dstRowBytes);
	rgb555 = (r << 10) | (g << 5) | b;
	
	switch( dropShadow )
	{
		case 0:
			while( height-- )
			{
				Byte *tSrc = src, *tDst = dst;
				
				for( index=0; index<width; index++ )
				{
					int workR, workG, workB, work, weightS, weightD;
					weightS = (*src >> 3) & 0x1F;
					
					if( weightS == 31 )
					{
						*(short*)dst = rgb555;
					}
					else if( weightS > 0 )
					{
						weightD = 32 - weightS;

						work = *(short*)dst;
						workB = ((((work    ) & 0x001F) * weightD) + (b * weightS)) >> 5;
						workG = ((((work>> 5) & 0x001F) * weightD) + (g * weightS));
						workR = ((((work>>10) & 0x001F) * weightD) + (r * weightS)) << 5;

						*(short*)dst = (workR & 0x7C00) | (workG & 0x03E0) | (workB & 0x001F);
					}
					
					src++;
					dst+=2;
				}
				
				src = tSrc + srcRowBytes;
				dst = tDst + dstRowBytes;
			}
			break;
		
		default:
			{
				Byte *drp = dst + ((dstRowBytes + 2) * dropShadow);
				
				while( height-- )
				{
					Byte *tSrc = src, *tDst = dst, *tDrp = drp;
					
					for( index=0; index<width; index++ )
					{
						int workR, workG, workB, work, weightS, weightD;
						weightS = (*src >> 3) & 0x1F;
						
						if( weightS == 31 )
						{
							*(short*)drp = 0;
							*(short*)dst = rgb555;
						}
						else if( weightS > 0 )
						{
							weightD = 32 - weightS;

							work = *(short*)drp;
							workB = ((((work    ) & 0x001F) * weightD)) >> 5;
							workG = ((((work>> 5) & 0x001F) * weightD));
							workR = ((((work>>10) & 0x001F) * weightD)) << 5;
							*(short*)drp = (workR & 0x7C00) | (workG & 0x03E0) | (workB & 0x001F);

							work = *(short*)dst;
							workB = ((((work    ) & 0x001F) * weightD) + (b * weightS)) >> 5;
							workG = ((((work>> 5) & 0x001F) * weightD) + (g * weightS));
							workR = ((((work>>10) & 0x001F) * weightD) + (r * weightS)) << 5;
							*(short*)dst = (workR & 0x7C00) | (workG & 0x03E0) | (workB & 0x001F);
						}
						
						src++;
						dst+=2;
						drp+=2;
					}
					
					src = tSrc + srcRowBytes;
					dst = tDst + dstRowBytes;
					drp = tDrp + dstRowBytes;
				}
				break;
			}
	}	
	dPoint->h += width;
}

void BlitWeightedCharacter( SkittlesFontPtr font, unsigned char text, Point *dPoint, int r, int g, int b, int alpha )
{		
	if( alpha == 31 )
	{
		BlitCharacter( font, text, dPoint, r, g, b, 0 );
	}
	else if( alpha == 0 )
	{
		return;
	}
	else
	{
		PixMapHandle dPixMap;
		Byte *src, *dst;
		int srcRowBytes, dstRowBytes;
		int index;
		GrafPtr thePort;
		
		int height = font->height;
		int width  = font->width[text];
		int across = font->across[text];
		
		GetPort( &thePort );
		dPixMap = GetPortPixMap( thePort );
		
		if( (dPoint->h + width)  > (**dPixMap).bounds.right           ||      // clipped?
		    (dPoint->v + height) > (**dPixMap).bounds.bottom          || 
		    dPoint->h < (**dPixMap).bounds.left ||
		    dPoint->v < (**dPixMap).bounds.top     )
		{
			dPoint->h += width;
			return;                                               // do nothing
		}
		
		srcRowBytes = font->rowBytes;
		dstRowBytes = dPixMap[0]->rowBytes & 0x3FFF;
		
		src = (Byte*) GetPixBaseAddr( font-> pixMap ) + across;
		dst = (Byte*) GetPixBaseAddr(       dPixMap ) + (dPoint->h * 2) + (dPoint->v * dstRowBytes);
		
		while( height-- )
		{
			Byte *tSrc = src, *tDst = dst;
			
			for( index=0; index<width; index++ )
			{
				int workR, workG, workB, work, weightS, weightD;
				weightS = (*src >> 3) & 0x1F;
				
				weightS = (weightS * alpha) >> 5;
				
				if( weightS )
				{
					weightD = 32 - weightS;

					work = *(short*)dst;
					workB = ((((work    ) & 0x001F) * weightD) + (b * weightS)) >> 5;
					workG = ((((work>> 5) & 0x001F) * weightD) + (g * weightS));
					workR = ((((work>>10) & 0x001F) * weightD) + (r * weightS)) << 5;

					*(short*)dst = (workR & 0x7C00) | (workG & 0x03E0) | (workB & 0x001F);
				}
				
				src++;
				dst+=2;
			}
			
			src = tSrc + srcRowBytes;
			dst = tDst + dstRowBytes;
		}
			
		dPoint->h += width;
	}
}

void BlitWeightedAlphaDualMask( PixMapHandle bPixMap, PixMapHandle sPixMap, PixMapHandle mPixMap, PixMapHandle aPixMap,
                                Rect *bckRect, Rect *srcRect, Rect *mskRect, Rect *alfRect, Rect *dstRect, int inWeight )
{
	PixMapHandle dPixMap;
	int startX = 0, startY = 0, endX, endY, x, y, startBit, bit, 
	    srcRowBytes, alfRowBytes, mskRowBytes, dstRowBytes, bckRowBytes;
	Byte *bck, *src, *alf, *msk, *dst;
	GrafPtr thePort;
	
	GetPort( &thePort );
	dPixMap = GetPortPixMap( thePort );
	
	endX = srcRect->right - srcRect->left;
	endY = srcRect->bottom - srcRect->top;

	if( dstRect->left   > (**dPixMap).bounds.right  ||			// completely clipped?
		dstRect->right  < (**dPixMap).bounds.left   ||
		dstRect->top    > (**dPixMap).bounds.bottom ||
		dstRect->bottom < (**dPixMap).bounds.top )
	{
		return; 												// do nothing
	}
	
	bck = (Byte*) GetPixBaseAddr( bPixMap ); 
	src = (Byte*) GetPixBaseAddr( sPixMap ); 
	alf = (Byte*) GetPixBaseAddr( aPixMap );
	msk = (Byte*) GetPixBaseAddr( mPixMap );
	dst = (Byte*) GetPixBaseAddr( dPixMap ); 
	
	bckRowBytes = GetPixRowBytes( bPixMap ); 
	srcRowBytes = GetPixRowBytes( sPixMap );
	alfRowBytes = GetPixRowBytes( aPixMap );
	mskRowBytes = GetPixRowBytes( mPixMap );
	dstRowBytes = GetPixRowBytes( dPixMap );
	
	bck += (bckRect->top * bckRowBytes) + (bckRect->left * 2);
	src += (srcRect->top * srcRowBytes) + (srcRect->left * 2);
	alf += (alfRect->top * alfRowBytes) + (alfRect->left * 2);
	dst += (dstRect->top * dstRowBytes) + (dstRect->left * 2);
	msk += (mskRect->top * mskRowBytes) + (mskRect->left / 8);
	
	if( dstRect->left   < (**dPixMap).bounds.left   ) startX -= dstRect->left - (**dPixMap).bounds.left;
	if( dstRect->right  > (**dPixMap).bounds.right  ) endX   -= dstRect->right - (**dPixMap).bounds.right;
	if( dstRect->top    < (**dPixMap).bounds.top    ) startY -= dstRect->top - (**dPixMap).bounds.top;
	if( dstRect->bottom > (**dPixMap).bounds.bottom ) endY   -= dstRect->bottom - (**dPixMap).bounds.bottom;
	
	bck += (bckRowBytes * startY) + (startX * 2);
	src += (srcRowBytes * startY) + (startX * 2);
	alf += (alfRowBytes * startY) + (startX * 2);
	dst += (dstRowBytes * startY) + (startX * 2);
	msk += (mskRowBytes * startY) + (startX / 8);
	startBit = 0x80 >> (startX & 7);
	
	for( y=startY; y<endY; y++ )
	{
		Byte *tSrc = src, *tAlf = alf, *tDst = dst, *tBck = bck, *tMsk = msk;
		int pixS, pixB, weightS, weightB, work, workB, workG, workR;
		
		bit = startBit;
		
		for( x=startX; x<endX; x++ )
		{
			if( *msk & bit )
			{
				work = *(short*)alf;
				workB = ((((work    ) & 0x001F)*inWeight) ) >> 5;
				workG = ((((work>> 5) & 0x001F)*inWeight) );
				workR = ((((work>>10) & 0x001F)*inWeight) ) << 5;

				weightB = ~((workR & 0x7C00) | (workG & 0x03E0) | (workB & 0x001F));
				
				if( weightB == 0x7FFF )
				{
					*(short*)dst = *(short*)bck;
				}
				else if( weightB == 0 )
				{
					*(short*)dst = *(short*)src;
				}
				else
				{
					weightS = ~weightB;

					pixS = *(short*)src;
					pixB = *(short*)bck;
									
					workB = ((((pixS      ) & 0x001F) * ((weightS      ) & 0x001F)) + (((pixB      ) & 0x001F) * ((weightB      ) & 0x001F))) >> 5;
					workG = ((((pixS >>  5) & 0x001F) * ((weightS >>  5) & 0x001F)) + (((pixB >>  5) & 0x001F) * ((weightB >>  5) & 0x001F)));
					workR = ((((pixS >> 10) & 0x001F) * ((weightS >> 10) & 0x001F)) + (((pixB >> 10) & 0x001F) * ((weightB >> 10) & 0x001F))) << 5;

					*(short*)dst = (workR & 0x7C00) | (workG & 0x03E0) | (workB & 0x001F);
				}
			}

			if( !(bit >>= 1) ) { msk++; bit = 0x80; }
			src+=2;
			alf+=2;
			bck+=2;
			dst+=2;
		}
		
		bck = tBck + bckRowBytes;
		src = tSrc + srcRowBytes;
		alf = tAlf + alfRowBytes;
		dst = tDst + dstRowBytes;
		msk = tMsk + mskRowBytes;
	}
}

void BlitColorMask( PixMapHandle mPixMap, Rect *srcRect, Rect *dstRect, int r, int g, int b, int weight )
{
	PixMapHandle dPixMap;
	int startX = 0, startY = 0, endX, endY, x, y, srcRowBytes, dstRowBytes;
	UInt32 bit, startBit, mask;
	Byte *src, *dst;
	GrafPtr thePort;
	
	GetPort( &thePort );
	dPixMap = GetPortPixMap( thePort );
	
	endX = srcRect->right - srcRect->left;
	endY = srcRect->bottom - srcRect->top;
	
	if( dstRect->left   > (**dPixMap).bounds.right  ||			// completely clipped?
		dstRect->right  < (**dPixMap).bounds.left   ||
		dstRect->top    > (**dPixMap).bounds.bottom ||
		dstRect->bottom < (**dPixMap).bounds.top )
	{
		return; 												// do nothing
	}
	
	src = (Byte*) GetPixBaseAddr( mPixMap );
	dst = (Byte*) GetPixBaseAddr( dPixMap );
	srcRowBytes = GetPixRowBytes( mPixMap ); 
	dstRowBytes = GetPixRowBytes( dPixMap ); 
	
	src += (srcRect->top * srcRowBytes) + (srcRect->left / 8);
	dst += (dstRect->top * dstRowBytes) + (dstRect->left * 2);
	
	if( dstRect->left   < (**dPixMap).bounds.left   ) startX -= dstRect->left - (**dPixMap).bounds.left;
	if( dstRect->right  > (**dPixMap).bounds.right  ) endX   -= dstRect->right - (**dPixMap).bounds.right;
	if( dstRect->top    < (**dPixMap).bounds.top    ) startY -= dstRect->top - (**dPixMap).bounds.top;
	if( dstRect->bottom > (**dPixMap).bounds.bottom ) endY   -= dstRect->bottom - (**dPixMap).bounds.bottom;
	
	startBit = 0x80000000 >> (startX & 31);
	src += (srcRowBytes * startY) + ((startX & ~31) / 8);
	dst += (dstRowBytes * startY) + (startX * 2);

	r *= weight;
	g *= weight;
	b *= weight;
	weight = 32 - weight;
	
	for( y=startY; y<endY; y++ )
	{
		Byte *tSrc = src, *tDst = dst;
		int work, workB, workG, workR;
		
		mask = *(int*)src;
		bit = startBit;
				
		for( x=startX; x<endX; x++ )
		{
			if( mask & bit )
			{
				work = *(short*)dst;
				workB = ((((work    ) & 0x001F)*weight) + b) >> 5;
				workG = ((((work>> 5) & 0x001F)*weight) + g);
				workR = ((((work>>10) & 0x001F)*weight) + r) << 5;

				*(short*)dst = (workR & 0x7C00) | (workG & 0x03E0) | (workB & 0x001F);
			}
			
			if( !(bit >>= 1) ) { src+=4; mask = *(int*)src; bit = 0x80000000; }
			dst+=2;
		}
		
		src = tSrc + srcRowBytes;
		dst = tDst + dstRowBytes;
	}
}

void BlitColorOver( PixMapHandle sPixMap, Rect *dstRect, int r, int g, int b, int weight )
{
	PixMapHandle dPixMap;
	int startX = 0, startY = 0, endX, endY, x, y, dstRowBytes, srcRowBytes;
	Byte *src, *dst;
	GrafPtr thePort;
	
	GetPort( &thePort );
	dPixMap = GetPortPixMap( thePort );
	
	endX = dstRect->right - dstRect->left;
	endY = dstRect->bottom - dstRect->top;
	
	if( dstRect->left   > (**dPixMap).bounds.right  ||			// completely clipped?
		dstRect->right  < (**dPixMap).bounds.left   ||
		dstRect->top    > (**dPixMap).bounds.bottom ||
		dstRect->bottom < (**dPixMap).bounds.top )
	{
		return; 												// do nothing
	}
	
	src = (Byte*) GetPixBaseAddr( sPixMap ); 
	dst = (Byte*) GetPixBaseAddr( dPixMap );  
	srcRowBytes = GetPixRowBytes( sPixMap ); 
	dstRowBytes = GetPixRowBytes( dPixMap );
	
	src += (dstRect->top * srcRowBytes) + (dstRect->left * 2);
	dst += (dstRect->top * dstRowBytes) + (dstRect->left * 2);
	
	if( dstRect->left   < (**dPixMap).bounds.left   ) startX -= dstRect->left - (**dPixMap).bounds.left;
	if( dstRect->right  > (**dPixMap).bounds.right  ) endX   -= dstRect->right - (**dPixMap).bounds.right;
	if( dstRect->top    < (**dPixMap).bounds.top    ) startY -= dstRect->top - (**dPixMap).bounds.top;
	if( dstRect->bottom > (**dPixMap).bounds.bottom ) endY   -= dstRect->bottom - (**dPixMap).bounds.bottom;
	
	src += (srcRowBytes * startY) + (startX * 2);
	dst += (dstRowBytes * startY) + (startX * 2);

	r *= weight;
	g *= weight;
	b *= weight;
	weight = 32 - weight;
	
	for( y=startY; y<endY; y++ )
	{
		Byte *tSrc = src, *tDst = dst;
		int work, workB, workG, workR;
		
		for( x=startX; x<endX; x++ )
		{
			work = *(short*)src;
			workB = ((((work    ) & 0x001F)*weight) + b) >> 5;
			workG = ((((work>> 5) & 0x001F)*weight) + g);
			workR = ((((work>>10) & 0x001F)*weight) + r) << 5;

			*(short*)dst = (workR & 0x7C00) | (workG & 0x03E0) | (workB & 0x001F);
			
			src+=2;
			dst+=2;
		}
		
		src = tSrc + srcRowBytes;
		dst = tDst + dstRowBytes;
	}
}

void BlitBlendOver( PixMapHandle sPixMap, Rect *dstRect, int r1, int g1, int b1, int r2, int g2, int b2, int r3, int g3, int b3, int r4, int g4, int b4, int weight )
{
	PixMapHandle dPixMap;
	int startX = 0, startY = 0, endX, endY, x, y, r, g, b, weight16, rI, gI, bI, vrLI, vgLI, vbLI, vrRI, vgRI, vbRI, width, height, dstRowBytes, srcRowBytes;
	Byte *src, *dst;
	GrafPtr thePort;
	
	GetPort( &thePort );
	dPixMap = GetPortPixMap( thePort );
	
	if( dstRect->left   > (**dPixMap).bounds.right  ||			// completely clipped?
		dstRect->right  < (**dPixMap).bounds.left   ||
		dstRect->top    > (**dPixMap).bounds.bottom ||
		dstRect->bottom < (**dPixMap).bounds.top )
	{
		return; 												// do nothing
	}

	endX = dstRect->right - dstRect->left;
	endY = dstRect->bottom - dstRect->top;
		
	src = (Byte*) GetPixBaseAddr( sPixMap ); 
	dst = (Byte*) GetPixBaseAddr( dPixMap );
	srcRowBytes = GetPixRowBytes( sPixMap ); 
	dstRowBytes = GetPixRowBytes( dPixMap ); 
	
	src += (dstRect->top * srcRowBytes) + (dstRect->left * 2);
	dst += (dstRect->top * dstRowBytes) + (dstRect->left * 2);
	
	if( dstRect->left   < (**dPixMap).bounds.left   ) startX -= dstRect->left - (**dPixMap).bounds.left;
	if( dstRect->right  > (**dPixMap).bounds.right  ) endX   -= dstRect->right - (**dPixMap).bounds.right;
	if( dstRect->top    < (**dPixMap).bounds.top    ) startY -= dstRect->top - (**dPixMap).bounds.top;
	if( dstRect->bottom > (**dPixMap).bounds.bottom ) endY   -= dstRect->bottom - (**dPixMap).bounds.bottom;
	
	src += (srcRowBytes * startY) + (startX * 2);
	dst += (dstRowBytes * startY) + (startX * 2);

	height = endY - startY;
	width  = endX - startX;
	
	weight16 = weight << 16;
	
	r1 *= weight16;		g1 *= weight16;		b1 *= weight16;	
	r2 *= weight16;		g2 *= weight16;		b2 *= weight16;	
	r3 *= weight16;		g3 *= weight16;		b3 *= weight16;	
	r4 *= weight16;		g4 *= weight16;		b4 *= weight16;	

	vrLI = (r3 - r1) / height;
	vgLI = (g3 - g1) / height;
	vbLI = (b3 - b1) / height;

	vrRI = (r4 - r2) / height;
	vgRI = (g4 - g2) / height;
	vbRI = (b4 - b2) / height;

	weight = 32 - weight;
	
	for( y=startY; y<endY; y++ )
	{
		Byte *tSrc = src, *tDst = dst;
		int work, workB, workG, workR;
		
		r  =  r1;
		g  =  g1;
		b  =  b1;

		rI = (r2 - r1) / width;
		gI = (g2 - g1) / width;
		bI = (b2 - b1) / width;
					
		for( x=startX; x<endX; x++ )
		{
			work = *(short*)src;
			workB = ((((work<<16) & 0x001F0000)*weight) + b) >> 21;
			workG = ((((work<<11) & 0x001F0000)*weight) + g) >> 16;
			workR = ((((work<< 6) & 0x001F0000)*weight) + r) >> 11;

			*(short*)dst = (workR & 0x7C00) | (workG & 0x03E0) | (workB & 0x001F);
			
			src+=2;
			dst+=2;
			
			r += rI;
			g += gI;
			b += bI;
		}
		
		src = tSrc + srcRowBytes;
		dst = tDst + dstRowBytes;

		r1 += vrLI; r2 += vrRI;
		g1 += vgLI; g2 += vgRI;
		b1 += vbLI; b2 += vbRI;
	}
}
/*
void BlitShadowMask( PixMapHandle mPixMap, Rect *srcRect, Rect *dstRect )
{
	PixMapHandle dPixMap;
	int startX = 0, startY = 0, endX, endY, x, y, bit, startBit, srcRowBytes, dstRowBytes;
	Byte *src, *dst;
		
	dPixMap = GetGWorldPixMap( (CGrafPtr) qd.thePort );
	
	endX = srcRect->right - srcRect->left;
	endY = srcRect->bottom - srcRect->top;

	if( dstRect->left   > (**dPixMap).bounds.right  ||			// completely clipped?
		dstRect->right  < (**dPixMap).bounds.left   ||
		dstRect->top    > (**dPixMap).bounds.bottom ||
		dstRect->bottom < (**dPixMap).bounds.top )
	{
		return; 												// do nothing
	}
	
	src = (Byte*) (**mPixMap).baseAddr;
	dst = (Byte*) (**dPixMap).baseAddr;
	srcRowBytes = (**mPixMap).rowBytes & 0x3FFF;
	dstRowBytes = (**dPixMap).rowBytes & 0x3FFF;
	
	src += (srcRect->top * srcRowBytes) + (srcRect->left / 8);
	dst += (dstRect->top * dstRowBytes) + (dstRect->left * 2);
	
	if( dstRect->left   < (**dPixMap).bounds.left   ) startX -= dstRect->left - (**dPixMap).bounds.left;
	if( dstRect->right  > (**dPixMap).bounds.right  ) endX   -= dstRect->right - (**dPixMap).bounds.right;
	if( dstRect->top    < (**dPixMap).bounds.top    ) startY -= dstRect->top - (**dPixMap).bounds.top;
	if( dstRect->bottom > (**dPixMap).bounds.bottom ) endY   -= dstRect->bottom - (**dPixMap).bounds.bottom;
	
	src += (srcRowBytes * startY) + (startX / 8);
	dst += (dstRowBytes * startY) + (startX * 2);
	startBit = 0x80 >> (startX & 7);
	
	for( y=startY; y<endY; y++ )
	{
		Byte *tSrc = src, *tDst = dst;
		int work;
		
		bit = startBit;
		for( x=startX; x<endX; x++ )
		{
			if( *src & bit )
			{
				work = *(short*)dst;
				*(short*)dst = ((work >> 1) & 0x3DEF) + ((work >> 2) & 0x1CE7) + ((work >> 3) & 0x0C63);
			}
			
			if( !(bit >>= 1) ) { src++; bit = 0x80; }
			dst+=2;
		}
		
		src = tSrc + srcRowBytes;
		dst = tDst + dstRowBytes;
	}
}
*/